
CLS


OPEN "vephddat.csv" FOR INPUT AS #1
IF EOF(1) GOTO 99

INPUT #1, defin$, a$
INPUT #1, defout$, a$

LINE INPUT #1, a$: rowstart = VAL(a$)
LINE INPUT #1, a$: rowstop = VAL(a$)
LINE INPUT #1, a$: columns = VAL(a$)
LINE INPUT #1, a$: mapcol = VAL(a$)
LINE INPUT #1, a$: rpmcol = VAL(a$)
LINE INPUT #1, a$: blm1col = VAL(a$)
LINE INPUT #1, a$: blm2col = VAL(a$)
LINE INPUT #1, a$: int1col = VAL(a$)
LINE INPUT #1, a$: int2col = VAL(a$)
LINE INPUT #1, a$: cellcol = VAL(a$)

LINE INPUT #1, a$
mapsegs = VAL(a$)
REDIM maplabel(mapsegs)
FOR i = 1 TO mapsegs
 IF EOF(1) GOTO 99
 LINE INPUT #1, a$
 maplabel(i) = VAL(a$)
NEXT i

LINE INPUT #1, a$
rpmsegs = VAL(a$)
REDIM rpmlabel(rpmsegs)
FOR i = 1 TO rpmsegs
 IF EOF(1) GOTO 99
 LINE INPUT #1, a$
 rpmlabel(i) = VAL(a$)
NEXT i

98 GOTO 100
99 IF EOF(1) THEN BEEP: PRINT "Parameter file incorrect, check it and make it right!"
STOP
100

CLOSE #1

REDIM rpmlow(rpmsegs), rpmhigh(rpmsegs), maplow(mapsegs), maphigh(mapsegs)

PRINT "File to be used for input  (c/r=default of  '"; defin$; "'";
INPUT a$: IF a$ = "" THEN infile$ = defin$ ELSE infile$ = a$

PRINT "File to be used for output (c/r=default of '"; defout$; "'";
INPUT a$: IF a$ = "" THEN outfile$ = defout$ ELSE outfile$ = a$

PRINT "From: "; infile$; "   To:"; outfile$
PRINT
PRINT "Check 'vephddat.csv' fine if things don't look right, you might need to "
PRINT "change the 'csv' input data format! It's all there, so dick around..."
PRINT

IF rowstop = 0 THEN rowstop = 999999

REDIM valout(12, rpmsegs, mapsegs), sumxsq(rpmsegs, mapsegs), title$(12), sumx(rpmsegs, mapsegs), n(rpmsegs, mapsegs)


title$(1) = "MAP"
title$(2) = "RPM"
title$(3) = "BLM1"
title$(4) = "BLM2"
title$(5) = "INT1"
title$(6) = "INT2"
title$(7) = "CELL"
title$(8) = "POINTS (also non-128)"
title$(9) = "NON-128 POINTS"
title$(10) = "Average of (BLM1*INT1 & BLM2*INT2) / 128^2"
title$(11) = "PCT STD DEVIATION IN BLM*INT/(128^2)"


FOR i = 2 TO mapsegs
 maplow(i) = .5 * (maplabel(i - 1) + maplabel(i))
NEXT i

FOR i = 1 TO mapsegs - 1
 maphigh(i) = .5 * (maplabel(i) + maplabel(i + 1))
NEXT i

FOR i = 2 TO rpmsegs
 rpmlow(i) = .5 * (rpmlabel(i - 1) + rpmlabel(i))
NEXT i

FOR i = 1 TO rpmsegs - 1
 rpmhigh(i) = .5 * (rpmlabel(i) + rpmlabel(i + 1))
NEXT i

maplow(1) = maplabel(1) - .5 * (maplabel(2) - maplabel(1))
rpmlow(1) = rpmlabel(1) - .5 * (rpmlabel(2) - rpmlabel(1))
maphigh(mapsegs) = maplabel(mapsegs) + .5 * (maplabel(mapsegs) - maplabel(mapsegs - 1))
rpmhigh(rpmsegs) = rpmlabel(rpmsegs) + .5 * (rpmlabel(rpmsegs) - rpmlabel(rpmsegs - 1))


' Input log data

OPEN infile$ FOR INPUT AS #2

FOR i = 1 TO rowstart - 1
 LINE INPUT #2, a$
NEXT i

FOR i = 1 TO rowstop - rowstart + 1

 FOR j = 1 TO columns
  IF EOF(2) GOTO 199
  INPUT #2, x
  IF j = mapcol THEN mapbuff = x
  IF j = rpmcol THEN rpmbuff = x
  IF j = blm1col THEN blm1buff = x
  IF j = blm2col THEN blm2buff = x
  IF j = int1col THEN int1buff = x
  IF j = int2col THEN int2buff = x
  IF j = cellcol THEN cellbuff = x
 NEXT j

 FOR k = 1 TO rpmsegs
  IF rpmbuff > rpmlow(k) AND rpmbuff <= rpmhigh(k) THEN

   FOR l = 1 TO mapsegs
    IF mapbuff > maplow(l) AND mapbuff <= maphigh(l) THEN

     IF blm1buff <> 128 OR blm2buff <> 128 OR int1buff <> 128 OR int2buff <> 128 THEN
      valout(1, k, l) = valout(1, k, l) + mapbuff
      valout(2, k, l) = valout(2, k, l) + rpmbuff
      valout(3, k, l) = valout(3, k, l) + blm1buff
      valout(4, k, l) = valout(4, k, l) + blm2buff
      valout(5, k, l) = valout(5, k, l) + int1buff
      valout(6, k, l) = valout(6, k, l) + int2buff
      valout(7, k, l) = valout(7, k, l) + cellbuff
      valout(8, k, l) = valout(8, k, l) + 1
      valout(9, k, l) = valout(9, k, l) + 1
      avgcorr = .5 * (blm1buff * int1buff + blm2buff * int2buff) / (128 ^ 2)
      valout(10, k, l) = valout(10, k, l) + avgcorr
     END IF

    END IF
   NEXT l

  END IF
 NEXT k

NEXT i

198 GOTO 200
199 BEEP: PRINT "EOF reached! Ended there... Datapoints = "; i; "."
200 CLOSE #2

' Calculate averages

FOR i = 1 TO 7
 FOR j = 1 TO rpmsegs
  FOR k = 1 TO mapsegs
   IF valout(8, j, k) <> 0 THEN
    valout(i, j, k) = valout(i, j, k) / valout(8, j, k)
    IF i = 7 THEN
     valout(10, j, k) = valout(10, j, k) / valout(8, j, k)
    END IF
   END IF
  NEXT k
 NEXT j
NEXT i

FOR i = 3 TO 6
 FOR j = 1 TO rpmsegs
  FOR k = 1 TO mapsegs
   IF valout(8, j, k) = 0 THEN
    valout(i, j, k) = 128
    IF i = 6 THEN
     valout(10, j, k) = 1
    END IF
   END IF
  NEXT k
 NEXT j
NEXT i


OPEN infile$ FOR INPUT AS #2

FOR i = 1 TO rowstart - 1
 LINE INPUT #2, a$
NEXT i

FOR i = 1 TO rowstop - rowstart + 1

 FOR j = 1 TO columns
  IF EOF(2) GOTO 399
  INPUT #2, x
  IF j = mapcol THEN mapbuff = x
  IF j = rpmcol THEN rpmbuff = x
  IF j = blm1col THEN blm1buff = x
  IF j = blm2col THEN blm2buff = x
  IF j = int1col THEN int1buff = x
  IF j = int2col THEN int2buff = x
 NEXT j

 FOR k = 1 TO rpmsegs
  IF rpmbuff > rpmlow(k) AND rpmbuff <= rpmhigh(k) THEN

   FOR l = 1 TO mapsegs
    IF mapbuff > maplow(l) AND mapbuff <= maphigh(l) THEN

     IF blm1buff <> 128 OR blm2buff <> 128 OR int1buff <> 128 OR int2buff <> 128 THEN
      avgcorr = .5 * (blm1buff * int1buff + blm2buff * int2buff) / (128 ^ 2)
      sumxsq(k, l) = sumxsq(k, l) + avgcorr ^ 2
      sumx(k, l) = sumx(k, l) + avgcorr
      n(k, l) = n(k, l) + 1
     END IF

    END IF
   NEXT l

  END IF
 NEXT k

NEXT i

398 GOTO 400
399 BEEP
400 CLOSE #2

FOR k = 1 TO rpmsegs
 FOR l = 1 TO mapsegs
  IF blm1buff <> 128 OR blm2buff <> 128 OR int1buff <> 128 OR int2buff <> 128 THEN
  
   IF (n(k, l) > 1) THEN
    valout(11, k, l) = ((n(k, l) * sumxsq(k, l) - sumx(k, l) ^ 2) / (n(k, l) ^ 2))
    IF valout(11, k, l) < 1E-08 THEN
     PRINT valout(11, k, l): valout(11, k, l) = 0
    END IF
    valout(11, k, l) = (100 * n(k, l) / sumx(k, l)) * valout(11, k, l) ^ .5
   END IF
   ELSE
    valout(11, k, l) = 0
  END IF
 NEXT l
NEXT k

OPEN outfile$ FOR OUTPUT AS #3: CLOSE #3: KILL outfile$

OPEN outfile$ FOR OUTPUT AS #1

PRINT #1, "Date/Time: "; DATE$; " "; TIME$
PRINT #1, ""


FOR i = 1 TO 11
PRINT #1, USING "Table ##"; i;
PRINT #1, ": "; title$(i)
PRINT #1, "RPM vs MAP,";
 FOR j = 1 TO mapsegs - 1
  PRINT #1, maplabel(j); ",";
 NEXT j
 PRINT #1, maplabel(mapsegs)

 FOR k = 1 TO rpmsegs
  PRINT #1, rpmlabel(k); ",";
 
  FOR l = 1 TO mapsegs - 1
   PRINT #1, valout(i, k, l); ",";
  NEXT l
 
  PRINT #1, valout(i, k, mapsegs)
 NEXT k

PRINT #1, ""

NEXT i

CLOSE #1

PRINT : PRINT : INPUT "Press enter to exit program"; a$

END


